// Site variables
// TO DO: make these into parts of an object?
var mydomain = "http://alastairc";
var imagefolder = "";

// Highlight links that are exnteral or documents.
// Relies on jQuery & shrinkUrl, called by DOM ready.
function linkHighlight() {
	
	// Find all content links that aren't image links.
	var links = $("#content a").filter(function(index) {
	  return $("img", this).length == 0;
	})
	
	$(links).each(function(i){
		
		var link = links[i];			// This link
		var url = $(link).attr("href");	// the URL
		var contents = $(link).text();	// The text of the link

		// Trim long URLs in the content of each link. First, incase it's a long external/document link.
		if( ( contents.indexOf("http://")==0 ) && ( contents.length>25 ) ) {
			var newContent = shrinkUrl(contents);
			$(link).empty().append(newContent);
		}

		// Match documents
		if (url.lastIndexOf(".doc") == (url.length-4)){
			$(link).addClass("highlightlink");
			$(link).append("<img src='" + imagefolder + "je_doc.png' class='highlightlink' alt='(Word document) ' title='Word document' />");
		}
		
		// Match PDFs
		if (url.lastIndexOf(".pdf") == (url.length-4)){
			$(link).addClass("highlightlink");
			$(link).append("<img src='" + imagefolder + "je_pdf.png' class='highlightlink' alt='(PDF document) ' title='PDF document' />");
		}
		
		// Match ZIPs
		if (url.lastIndexOf(".zip") == (url.length-4)){
			$(link).addClass("highlightlink");
			$(link).append("<img src='" + imagefolder + "je_zip.png' class='highlightlink' alt='(Zip file) ' title='Zip file' />");
		}
		
		// Match external links
		if( ( url.indexOf("http://")==0) && ( url.indexOf(mydomain)!=0 ) ) {
			// Add image icon with title. NB: didn't include alt, as that would disrupt reading too much.
			$(link).append("<img src='" + imagefolder + "je_outbound.png' title='external site' class='highlightlink' alt='' />");
			$(link).addClass("highlightlink");
		}
	
		// Match withpage links
		// TO DO: disect the URL so it's not just for within page links?
		if( ( url.indexOf("#")==0)) {
			// Add image icon with title.
			$(link).append("<img src='" + imagefolder + "je_down.png' title='Within page link' class='highlightlink' alt='' />");
			$(link).addClass("highlightlink");
		}
		
		
	}); // end each
} // end linkHighlight

// Add anchor background to each heading with an ID.
// Relies on jQuery, called by DOM ready.
function headingAnchors(){

	var headings = $("#content h2[@id], #content h3[@id]");
	$(headings).each(function(i){

		var heading = headings[i];		// This heading
		var hId = $(heading).attr("id");	// get the ID.
		$(heading).attr("tabindex", "0");	// add a tab index to the headings
		
		// Create an anchor to add.
		var anchor = "<a href='#" + hId + "' class='hidden highlightlink'><img src='" + imagefolder + "je_anchor.png' title='within page anchor' class='highlightlink' alt='' /> #" + hId + "</a>";
		
		// Add hover event to heading. Not sure this is a very effective use of jQuery.
		$(heading).append(anchor);
		$(heading).hover(function(){
			//alert("#" + hId + " > a");
		    $("#" + hId + " > a").removeClass("hidden");
		},function(){
		  $("#" + hId + " > a").addClass("hidden");
		});

		// Add keyboard events as equivelent
		$(heading).focus(function() { $("#" + hId + " > a").removeClass("hidden"); } );
		$(heading).blur(function() { $("#" + hId + " > a").addClass("hidden"); } );	
	}); // end each
}

// Take in blockquotes and q elements that have cite attributes to show the link and allow people to click on it.
// Relies on jQuery and shrinkUrl.
function quotes(){
    var quotes = $("#content blockquote, #content q");

	$(quotes).each(function(i){
		
		var quote = quotes[i];
		//	Get the cite and title attributes.
		var source 	= $(quote).attr("cite"); 
		var t 		= $(quote).attr("title");

		if(source) {  // If there is a cite
			// add class and onclick.
			$(quote).addClass("linked");
			$(quote).click(goToCite);

			// change status bar, if browser allows it. Not sure how to get around middle clicking?
			$(quote).hover(function(){
			  window.status=source;
			},function(){
			  window.status='';
			});

			// if there isn't a title already, create it from the URL.
			if(!t){
				t= "Go to: " + shrinkUrl(source);
			}	

			$(quote).attr("title", t);

			if($(quote).is("blockquote")){
				$(quote).append("<address><a href='"+ source +"'>" + t + "</a></address>");
			}
		}
		
	}); // end each
} // end blockquotes


// Folow cite from a quote, i.e. change location
// Called by convertQuote
function goToCite(){
	var cite=this.getAttribute('cite');
	location.href=cite;
}


// Shrink longer URLs by taking out the middle. 
// Called by convertQuote & linkHighlight
function shrinkUrl(longUrl){
	if((longUrl.length<=25)||(longUrl.indexOf('http')!=0)) return longUrl.substring(7);
	var l=longUrl.length;
	var firstUrlPart=longUrl.substring(7,24);
	var lastUrlPart=longUrl.substring(l-15,l);
	var shortUrl=firstUrlPart+'...'+lastUrlPart;
	return shortUrl;
}

// Functions to call on DOM ready.
$(document).ready(function() {
	linkHighlight();
	headingAnchors();
	quotes();
});
